//Program Title: To study and perform various image segmentation techniques.
//Program Description: This scilab code is used to perform segmentation operations like edge detection using sobel, canny , prewitt operators, thresholding and Morphoogical operations like dilation, erosion, opening, closing on an image.

//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 8.1 Pro, 64 bit
//Scilab version: 5.5.2 (Tested on 64 bit version)
//Toolbox used: SIVP - Scilab Image and Video Processing Toolbox (Version 0.5.3.2)
//Reference book name : Digital Image Processing (author : Rafael C.Gonzalez and Richard E.Woods)

clear;
clc;
clear all;
close;

img = imread("ip1_lena.jpg");     // input image 1 --> ip1_lena.jpg
img_gray = rgb2gray(img);
figure();
xname("Input image 1");
imshow(img_gray);

// EDGE DETECTION
[v,h] = size(img_gray);

v_sobel = [-1, 0, 1; -2,0,2; -1,0,1];
disp(v_sobel);

img_gray_v = conv2(double(img_gray), v_sobel);
figure();
xname("Vertical Edge Detection image");
imshow(img_gray_v);
imwrite(img_gray_v,'ver.jpg')

h_sobel = [-1, -2, -1; 0,0,0; 1,2,1];
disp(h_sobel);
img_gray_h = conv2(double(img_gray), h_sobel);            
figure();
xname("Horizontal Edge Detection image");
imshow(img_gray_h);
imwrite(img_gray_h,'hori.jpg')

img_res = img_gray_h + img_gray_v;
figure();
xname("Sum of Edge Detection image");
imshow(img_res);
imwrite(img_res,'sum.jpg')

// Edge Detection using in-built functions
E = edge(img_gray, 'sobel');
figure();
xname("Sobel edge detection");
imshow(E);
imwrite(E,'sobel.jpg')

E2 = edge(img_gray, 'canny', [0.06, 0.2]);
figure();
xname("Canny edge detection");
imshow(E2);
imwrite(E2,'canny.jpg')

E3 = edge(img_gray, 'prewitt');
figure();
xname("Prewitt edge detection");
imshow(E3);
imwrite(E3,'prewitt.jpg')

//THRESHOLDING
img_thresh = int(img_gray/128)*255;
figure();
xname("Global Thresholding");
imshow(img_thresh);
imwrite(img_thresh,'threshold.jpg');

//*********************************     MORPHOLOGICAL PROCESSING    *************************
img = imread("ip2_thanks.jpg");     // input image 2 --> ip2_thanks.jpg
img_gray = rgb2gray(img);
figure();
xname("Input image 2");
imshow(img_gray);
// Dilation, Erosion, Opening, Closing
[m,n] = size(img_gray)
padded_img = zeros(m+2,n+2);

//create image with zeros padded at the boundaries
u=2;
v=2;
for x=1:m
    for y=1:n
        padded_img(u,v) = img_gray(x,y);
        v = v+1;
    end
    u = u+1;
    v = 2;
    
end

arr = zeros(1,9);

u=1;v=1;
for x=2:m+1
    for y=2:n+1
        arr(1,1) = padded_img(x-1,y-1);
        arr(1,2) = padded_img(x-1,y);
        arr(1,3) = padded_img(x-1,y+1);
        arr(1,4) = padded_img(x,y-1);
        arr(1,5) = padded_img(x,y);
        arr(1,6) = padded_img(x,y+1);
        arr(1,7) = padded_img(x+1,y-1);
        arr(1,8) = padded_img(x+1,y);
        arr(1,9) = padded_img(x+1,y+1);
        img_max(x,y) = max(arr);
        img_min(x,y) = min(arr);   
        v=v+1;
    end  
    u=u+1;  
end

//remove padded zeros
for x=2:m+1
    for y=2:n+1
        dilated_img(x-1,y-1) = img_max(x,y);
    end
end

//remove padded zeros
for x=2:m+1
    for y=2:n+1
        eroded_img(x-1,y-1) = img_min(x,y);
    end
end





//Display dilated image
figure(); 
xname("Dilated image");
imshow(uint8(dilated_img));
imwrite(uint8(dilated_img),'dilate.jpg')

//Display eroded image
figure(); 
xname("Eroded image");
imshow(uint8(eroded_img));
imwrite(uint8(eroded_img),'erode.jpg')

///////////////////////////////////////////////////
//Opening:  erosion followed dilation
padded_img = zeros(m+2,n+2);

//create image with zeros padded at the boundaries
u=2;
v=2;
for x=1:m
    for y=1:n
        padded_img(u,v) = eroded_img(x,y);
        v = v+1;
    end
    u = u+1;
    v = 2;
    
end

arr = zeros(1,9);

u=1;v=1;
for x=2:m+1
    for y=2:n+1
        arr(1,1) = padded_img(x-1,y-1);
        arr(1,2) = padded_img(x-1,y);
        arr(1,3) = padded_img(x-1,y+1);
        arr(1,4) = padded_img(x,y-1);
        arr(1,5) = padded_img(x,y);
        arr(1,6) = padded_img(x,y+1);
        arr(1,7) = padded_img(x+1,y-1);
        arr(1,8) = padded_img(x+1,y);
        arr(1,9) = padded_img(x+1,y+1);
        img_max(x,y) = max(arr);   
        v=v+1;
    end  
    u=u+1;  
end

//remove padded zeros
for x=2:m+1
    for y=2:n+1
        opening_img(x-1,y-1) = img_max(x,y);
    end
end

//Display Closing image
figure(); 
xname("Opening image");
imshow(uint8(opening_img));
imwrite(uint8(opening_img),'opening.jpg')

///////////////////////////////////////////////////
//Closing:  dilation followed erosion
padded_img = zeros(m+2,n+2);

//create image with zeros padded at the boundaries
u=2;
v=2;
for x=1:m
    for y=1:n
        padded_img(u,v) = dilated_img(x,y);
        v = v+1;
    end
    u = u+1;
    v = 2;
    
end

arr = zeros(1,9);

u=1;v=1;
for x=2:m+1
    for y=2:n+1
        arr(1,1) = padded_img(x-1,y-1);
        arr(1,2) = padded_img(x-1,y);
        arr(1,3) = padded_img(x-1,y+1);
        arr(1,4) = padded_img(x,y-1);
        arr(1,5) = padded_img(x,y);
        arr(1,6) = padded_img(x,y+1);
        arr(1,7) = padded_img(x+1,y-1);
        arr(1,8) = padded_img(x+1,y);
        arr(1,9) = padded_img(x+1,y+1);
        img_min(x,y) = min(arr);   
        v=v+1;
    end  
    u=u+1;  
end

//remove padded zeros
for x=2:m+1
    for y=2:n+1
        closing_img(x-1,y-1) = img_min(x,y);
    end
end

//Display Closing image
figure(); 
xname("Closing image");
imshow(uint8(closing_img));
imwrite(uint8(closing_img),'closing.jpg')


